/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package catchClauses;

import java.io.FileNotFoundException;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class StartHere {

    public static void main(String[] args) {
//Handling more than one exception from the same block of code
        try {
            memoryProblems();
            arrayProblems();
            double result = arithmeticProblems(1, 0);
            //Catching more than one excepition
        } catch (OutOfMemoryError oom) {
            System.out.println("There is not enough memory to run this program.");
        } catch (ArithmeticException ae){
            System.out.println("There is a problem with the code: "+ae.getMessage());
        } catch (ArrayIndexOutOfBoundsException oob){
            System.out.println("There is a problem with the code: "+oob.getMessage());
/*
        //Combine the Arithmetic and ArrayIndexOutOfBounds exceptions
        } catch (ArithmeticException | ArrayIndexOutOfBoundsException e) {
            System.out.println("There is a problem with the code: " + e.getMessage());
*/
        } catch (Exception e) {
            e.getMessage();
        }
    }

    //Methods which raise some common exceptions and errors.
    public static void memoryProblems() {
        throw new OutOfMemoryError();
    }

    public static void arrayProblems() {
        int[] myArray = {1, 2, 3};
        //This will generate an ArrayIndexOutOfBoundException
        System.out.println("Value in position 4: " + myArray[3]);
    }

    public static double arithmeticProblems(int a, int b) {
        //This could generate an ArithmeticException.
        return a / b;
    }

    public static void fileProblems() throws FileNotFoundException {
        //Causes a checked exception but doesn't have a try catch clause to deal with it.
        //Hence must have the throws FileNotFoundException declaration in the method header above.
        throw new FileNotFoundException();
    }
}
